
  NAME CpCalls

Sysdep_CGROUP GROUP Sysdep_CODE

NULLBYTE EQU  0FFh

PUBLIC SetCpCallsInterrupt

EXTRN CpSetKeyHandler : FAR
EXTRN CpCatchAll : FAR
EXTRN CpEnableInterrupt : FAR
EXTRN CpDisableInterrupt : FAR
EXTRN CpSetInterrupt : FAR
EXTRN CpEndOfInterrupt : FAR
EXTRN CpSystemTick : FAR
EXTRN CpRealTimeClock : FAR
EXTRN CpMachineID : FAR
EXTRN OsNewQElement : FAR
EXTRN OsInitQCB : FAR
EXTRN OsElementChecksum : FAR
EXTRN OsVerifyChecksum : FAR
EXTRN OsInsertIntoQ : FAR
EXTRN OsRemoveFromQ : FAR
EXTRN OsReplaceInQ : FAR
EXTRN OsElementInQ : FAR
EXTRN OsSearchInQ : FAR
EXTRN CpFree : FAR
EXTRN CpGetSize : FAR
EXTRN IntAllocate : FAR
EXTRN SmartIntAllocate : FAR
EXTRN CpAllocate : FAR
EXTRN CpFreeTaskMem : FAR
EXTRN CpGetMemStatus : FAR
EXTRN CpWhoAmI : FAR
EXTRN Reschedule : FAR
EXTRN CpWait : FAR
EXTRN CpSend : FAR
EXTRN CpReceive : FAR
EXTRN CpCreateProcess : FAR
EXTRN CpDeleteProcess : FAR
EXTRN CpDelay : FAR
EXTRN CpSetPriority : FAR
EXTRN CpCreateSemaphore : FAR
EXTRN CpDeleteSemaphore : FAR
EXTRN Upper : FAR
EXTRN CompareChars : FAR
EXTRN MakeChecksum : FAR
EXTRN SetException : FAR
EXTRN Exception : FAR
EXTRN CpAddressOf : FAR
EXTRN CpSignal : FAR
EXTRN TellMessageWaiters : FAR
EXTRN SysdepInvalidCall : FAR

; System dependent routines
EXTRN GetDeviceList: FAR
EXTRN GfxSetPixel: FAR
EXTRN GfxClrPixel: FAR
EXTRN GfxInvertPixel: FAR
EXTRN GfxTestPixel: FAR
EXTRN GfxDrawLine: FAR
EXTRN GfxEraseLine: FAR
EXTRN GfxInvertLine: FAR
EXTRN BitInvertHLine: FAR
EXTRN BitEraseHLine: FAR
EXTRN CpCopyRectangle: FAR
EXTRN BlitRectangle: FAR
EXTRN CpScreenInfo: FAR
EXTRN CpDrawChars: FAR
EXTRN CpGetTime: FAR
EXTRN xCpGetMySlot: FAR
EXTRN xCpSetActiveSlot: FAR
EXTRN xCpGetSlotAddress: FAR
EXTRN ExceptionHandler: FAR
EXTRN UnresolvedMessage: FAR
EXTRN CpGetMemSize: FAR

EXTRN EmsAllocate: FAR
EXTRN EmsFree: FAR
EXTRN EmsStartAddress: FAR
EXTRN EnterWindows: FAR
EXTRN LeaveWindows: FAR
EXTRN CharHeight: FAR
EXTRN CharWidth: FAR
EXTRN LineHeight: FAR
EXTRN WinGetWindowExtent: FAR
EXTRN WinSetClip: FAR
EXTRN WinResetClip: FAR
EXTRN WinDrawPixel: FAR
EXTRN WinErasePixel: FAR
EXTRN WinDrawChars: FAR
EXTRN WinInvertLine: FAR
EXTRN WinInvertRectangle: FAR
EXTRN WinCopyRemoteRectangle: FAR
EXTRN WinEraseRectangle: FAR
EXTRN WinScrollRectangle: FAR
EXTRN WinFrameWindow: FAR
EXTRN WinEraseWindow: FAR
EXTRN WinInitDefaultWindow: FAR
EXTRN WinSetAlternateWindow: FAR

EXTRN LdrUnresolvedMessage: FAR
EXTRN EmsGetMemStatus: FAR
$EJECT

Sysdep_CODE SEGMENT PARA PUBLIC 'CODE'
  ASSUME CS:Sysdep_CGROUP

routines DD CpSetKeyHandler
         DD SysdepInvalidCall       ;CpSetWatchDogHandler
         DD CpCatchAll
         DD CpEnableInterrupt
         DD CpDisableInterrupt
         DD CpSetInterrupt
         DD CpEndOfInterrupt
         DD CpSystemTick
         DD CpRealTimeClock
         DD CpMachineID
         DD OsNewQElement
         DD OsInitQCB
         DD OsElementChecksum
         DD OsVerifyChecksum
         DD OsInsertIntoQ
         DD OsRemoveFromQ
         DD OsReplaceInQ
         DD OsElementInQ
         DD OsSearchInQ
         DD CpFree
         DD CpGetSize
         DD IntAllocate
         DD CpAllocate
         DD SysdepInvalidCall       ;CpMemInit
         DD CpFreeTaskMem
         DD CpGetMemStatus
         DD CpWhoAmI
         DD Reschedule
         DD CpWait
         DD CpSend
         DD CpReceive
         DD CpCreateProcess
         DD CpDeleteProcess
         DD CpDelay
         DD CpSetPriority
         DD CpCreateSemaphore
         DD CpDeleteSemaphore
         DD Upper
         DD CompareChars
         DD MakeChecksum
         DD SetException
         DD Exception
         DD CpAddressOf
         DD CpSignal
         DD TellMessageWaiters
         DD SysdepInvalidCall       ;CnoCharOut
         DD SysdepInvalidCall       ;CnoLineOut
         DD SysdepInvalidCall       ;CpSetMessageHandler
         DD SysdepInvalidCall       ;CpLogError
         DD SysdepInvalidCall       
         DD SysdepInvalidCall       
         DD SysdepInvalidCall       
         DD SysdepInvalidCall       
         DD SysdepInvalidCall       
; System Dependent Calls
         DD SysdepInvalidCall       ;DoOsMemInit
         DD GetDeviceList
         DD SysdepInvalidCall       ;SetSystemID
         DD GfxSetPixel
         DD GfxClrPixel
         DD GfxInvertPixel
         DD GfxTestPixel
         DD GfxDrawLine
         DD GfxEraseLine
         DD GfxInvertLine
         DD BitInvertHLine
         DD BitEraseHLine
         DD CpCopyRectangle
         DD BlitRectangle
         DD SysdepInvalidCall       ;InitSysdepVars
         DD CpScreenInfo
         DD SysdepInvalidCall       ;SetDoClippingRect
         DD CpDrawChars
         DD SysdepInvalidCall       ;SetUDISystemId
         DD SysdepInvalidCall       ;CpPartitionInfo
         DD CpGetTime
         DD SysdepInvalidCall       ;CpSetTime
         DD xCpGetMySlot
         DD SysdepInvalidCall       ;xCpBankInfo
         DD xCpSetActiveSlot
         DD xCpGetSlotAddress
         DD ExceptionHandler
         DD UnresolvedMessage
         DD SmartIntAllocate
         DD CpGetMemSize

         DD EmsAllocate
         DD EmsFree
         DD SysdepInvalidCall       ;EmsSaveContext
         DD SysdepInvalidCall       ;EmsSetActiveRam
         DD EmsStartAddress
         DD EnterWindows
         DD LeaveWindows
         DD CharHeight
         DD CharWidth
         DD LineHeight
         DD WinGetWindowExtent
         DD WinSetClip
         DD WinResetClip
         DD WinDrawPixel
         DD WinErasePixel
         DD WinDrawChars
         DD WinInvertLine
         DD WinInvertRectangle
         DD WinCopyRemoteRectangle
         DD WinEraseRectangle
         DD WinScrollRectangle
         DD WinFrameWindow
         DD WinEraseWindow
         DD WinInitDefaultWindow
         DD WinSetAlternateWindow

         DD LdrUnresolvedMessage    ; Unresolved message for loader
         DD EmsAllocate             ; New interrupt for new interface
         DD EmsGetMemStatus
$EJECT

IntrEntry LABEL FAR
  JMP  SHORT InterruptEntry

IndrEntry:
  JMP  SHORT IndirectEntry

jumpTable:
  DW  routines
  DW  SYSDEP_CGROUP
parms:
  DW 0fh
  DW 0ffffh
routineCount:
  DB 112


InterruptEntry:
  POP  BX                        ; get IP
  POP  ES                        ; get CS
  POPF                           ; set flags

  MOV  AX, ES:[BX]               ; get call #
  XOR  AH, AH
  INC  BX                        ; skip call #

  PUSH ES                        ; push CS
  PUSH BX                        ; push IP

IndirectEntry:
  MOV  BX, AX                    ; table index
  CMP  BL, BYTE PTR routineCount
  JB   LookItUp

  CALL SysdepInvalidCall         ; invalid routine number - abort

LookItUp:
  SHL  BX, 1
  SHL  BX, 1                     ; bx = bx * 4

  LES  DI, DWORD PTR jumpTable
  JMP  DWORD PTR ES:[DI+BX]      ; go to the routine
$EJECT


;  ASSUME DS:Sysdep_DGROUP

SetCpCallsInterrupt PROC NEAR
  XOR  AX, AX
  MOV  ES, AX

  CLI

  MOV  AX, 4 * 113
  MOV  BX, AX

  MOV  AX, SEG IntrEntry                ; Store InteGRiD's Int 71h Rtn Base
  MOV  ES:[BX+2], AX

  MOV  AX, OFFSET Sysdep_CODE:IntrEntry ; Store InteGRiD's Int 71h Rtn Offset
  MOV  ES:[BX+0], AX

; STI
  RET
SetCpCallsInterrupt ENDP

Sysdep_CODE ENDS

  END
